// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"

// RSA variables and math procedures for Top Secret Crypto.
//.........................................................
BYTE		ASN_SEQ[] = {0x30, 0x20, 0x30, 0x0c, 0x06, 0x08, 0x2a,
						 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x02, 0x05,
						 0x05, 0x00, 0x04, 0x10};

BYTE		SHA1_SEQ[] = {0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2b,
						  0x0e, 0x03, 0x02, 0x1a, 0x05, 0x00, 0x04, 0x14};

// Currently not used in the program.
//...................................
//BYTE		SHA256_SEQ[] = {0x30,0x31,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,
//						    0x65,0x03,0x04,0x02,0x01,0x05,0x00,0x04,0x20};

//BYTE		SHA384_SEQ[] = {0x30,0x41,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,
//						    0x65,0x03,0x04,0x02,0x02,0x05,0x00,0x04,0x30};

BYTE		SHA512_SEQ[] = {0x30,0x51,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,
							0x65,0x03,0x04,0x02,0x03,0x05,0x00,0x04,0x40};

// Used by CountBBD to return the number of bits, bytes, and dwords.
//..................................................................
DWORD		dwCountBits;
DWORD		dwCountBytes;
DWORD		dwCountDwords;

// Use by the functions to check to see if we have cancelled
// the current operation. Set to TRUE if we want to cancel.
// Set to FALSE at the beginning of the operation.
//..........................................................
BOOL		bCancelOperation;

// Variables used in the RSA key calculations.
//............................................
DWORD		dwN_Bits;			// Min 480, max 8192
DWORD		dwN_Bytes;

DWORD		dwP_Bits;
DWORD		dwP_Bytes;
DWORD		dwP_Dwords;

DWORD		dwQ_Bits;
DWORD		dwQ_Bytes;
DWORD		dwQ_Dwords;

DWORD		dwE_Bytes;
DWORD		dwD_Bytes;
DWORD		dwU_Bytes;
			
// Variables to hold the various components of the RSA keys.
// The RSA numbers are stored LSB to MSB for calculations,
// but changed to MSB to LSB when transferred to a file. This
// is to maintain compatability with PGP. Currently the maximum
// size of Modulus n is 8,192 bits or 1,024 bytes. This makes
// Primes p and q 512 bytes. They all contain 4 bytes, 32 bits,
// of slop for the calculations that need them.
//..............................................................
WORD		Prime_P_Mpi;
BYTE		Prime_P[MAX_PRIME_SLOP];

WORD		Prime_Q_Mpi;
BYTE		Prime_Q[MAX_PRIME_SLOP];

WORD		Mod_N_Mpi;
BYTE		Modulus_N[MAX_MOD_SLOP*2];

WORD		E_Mpi;
BYTE		E_Temp[MAX_MOD_SLOP];

BYTE		Q_Temp[MAX_PRIME_SLOP];
BYTE		P_Temp[MAX_PRIME_SLOP];

WORD		D_Mpi;
BYTE		D_Temp[MAX_MOD_SLOP];

WORD		U_Mpi;
BYTE		U_Temp[MAX_MOD_SLOP];

// Temporary variables used by the calculations. They contain
// 4 bytes, 32 bits, of slop for the calculations that need it.
//.............................................................
BYTE		Temp1[MAX_MOD_SLOP*2];
BYTE		Temp2[MAX_MOD_SLOP*2];
BYTE		Temp3[MAX_MOD_SLOP*2];
BYTE		Temp4[MAX_MOD_SLOP*2];
BYTE		Temp5[MAX_MOD_SLOP*2];
BYTE		Temp6[MAX_MOD_SLOP*2];
BYTE		Temp9[MAX_MOD_SLOP];

// Clear all variables.
//.....................
VOID ClearAllVariables()
{
	U_Mpi = 0;
	D_Mpi = 0;
	E_Mpi = 0;
	Prime_Q_Mpi = 0;
	Prime_P_Mpi = 0;
	Mod_N_Mpi = 0;
	dwU_Bytes = 0;
	dwD_Bytes = 0;
	dwE_Bytes = 0;
	dwQ_Dwords = 0;
	dwQ_Bytes = 0;
	dwQ_Bits = 0;
	dwP_Dwords = 0;
	dwP_Bytes = 0;
	dwP_Bits = 0;
	dwN_Bytes = 0;
	dwN_Bits = 0;
	dwCountBits = 0;
	dwCountBytes = 0;
	dwCountDwords = 0;

	ClearEncVariables();

	ZeroMemory(&Prime_P,MAX_PRIME_SLOP);
	ZeroMemory(&Prime_Q,MAX_PRIME_SLOP);
	ZeroMemory(&Modulus_N,MAX_MOD_SLOP);
	ZeroMemory(&E_Temp,MAX_MOD_SLOP);
	ZeroMemory(&Q_Temp,MAX_PRIME_SLOP);
	ZeroMemory(&P_Temp,MAX_PRIME_SLOP);
	ZeroMemory(&D_Temp,MAX_MOD_SLOP);
	ZeroMemory(&U_Temp,MAX_MOD_SLOP);
}

// Multiprecision decrement functions that operates on dwords.
//............................................................
VOID MpDecDW(LPBYTE lpOperand, DWORD dwOpDwords)
{
	if (dwOpDwords)
	{
		__asm
		{
			mov		edi,lpOperand
			mov		ecx,dwOpDwords
			xor		esi,esi
			stc					// 1 to subtract from number
			align	4
		L1:	sbb		dword ptr [edi][esi*4],0
			jnc		L2
			inc		esi
			dec		ecx
			jnz		L1
		L2:
		}
	}
}

// Multiprecision increment function. Works on DWORDS.
//....................................................
VOID MpIncDW(LPBYTE lpOperand, DWORD dwOpDwords)
{
	if (dwOpDwords)
	{
		__asm
		{
			mov		edi,lpOperand
			mov		ecx,dwOpDwords
			xor		esi,esi
			stc					// 1 to add to the number
			align	4
		L1:	adc		dword ptr [edi][esi*4],0
			jnc		L2
			inc		esi
			dec		ecx
			jnz		L1
		L2:
		}
	}
}

// Rotate a bit field left the number of bits passed. Takes
// the end bit and rotates it into the first bit of the string.
//.............................................................
VOID RotateBitFieldLeft(LPBYTE lpBitField, DWORD dwByteCount, DWORD dwShiftCount)
{
	__asm
	{
		mov		esi,lpBitField
		mov		edi,esi
		add		edi,dwByteCount
		dec		edi					// Last byte of bit field
		mov		ecx,dwShiftCount
	L1: push	ecx
		mov		ecx,dwByteCount
		xor		ebx,ebx

		// Put the last bit in the string into the carry flag
		// for rotating into the first bit of the string.
		//...................................................
		mov		al,byte ptr [edi]
		bt		eax,7
	L2: rcl		byte ptr [esi][ebx],1
		inc		ebx
		dec		ecx
		jnz		L2
		pop		ecx
		dec		ecx
		jnz		L1
	}
}

// Rotate a bit field right the number of bits passed. Takes
// the first bit and rotates it into the last bit of the string.
//..............................................................
VOID RotateBitFieldRight(LPBYTE lpBitField, DWORD dwByteCount, DWORD dwShiftCount)
{
	__asm
	{
		mov		esi,lpBitField
		mov		ecx,dwShiftCount
	L1: push	ecx
		mov		ecx,dwByteCount
		mov		ebx,ecx
		dec		ebx				// Index to last byte

		// Put the first bit of the string into the carry flag
		// to be rotated into the last bit of the string.
		//....................................................
		bt		dword ptr [esi],0
	L2: rcr		byte ptr [esi][ebx],1
		dec		ebx
		dec		ecx
		jnz		L2
		pop		ecx
		dec		ecx
		jnz		L1
	}
}

// Perform a checksum on a MPI nubmer. Since it is a plain
// addition checksum it does not matter what order it is in.
// Returns 16 bit checksum in a dword.
//..........................................................
DWORD CheckSum(LPBYTE lpOperand, DWORD dwByteCount)
{
	__asm
	{
		mov		esi,lpOperand
		mov		ecx,dwByteCount
		xor		eax,eax
		xor		edx,edx
	L1:	lodsb
		add		dx,ax
		dec		ecx
		jnz		L1
		mov		eax,edx
	}
}

// Circle swap reverses the order of bytes in an array.
//.....................................................
VOID CircleSwap(LPBYTE lpOperand, DWORD dwByteCount)
{
	__asm
	{
		mov		esi,lpOperand
		mov		edi,esi
		add		edi,dwByteCount
		dec		edi
		jmp		L2
		align	4
	L1:	mov		al,byte ptr [edi]
		mov		dl,byte ptr [esi]
		mov		byte ptr [edi],dl
		mov		byte ptr [esi],al
		inc		esi
		dec		edi
	L2: cmp		esi,edi
		jb		L1
	}
}

// Multiprecision add function. Works on dwords.
//..............................................
VOID MpAddDW(LPBYTE lpDestination, LPBYTE lpSource, DWORD dwDwordCount)
{
	if (dwDwordCount)
	{
		__asm
		{
			mov		edi,lpDestination
			mov		esi,lpSource
			mov		ecx,dwDwordCount
			xor		edx,edx
			clc
			align	4
		L1:	mov		eax,dword ptr [esi][edx*4]
			adc		dword ptr [edi][edx*4],eax
			inc		edx
			dec		ecx
			jnz		L1
			jnc		L2
			mov		eax,eax
		L2:
		}
	}	
}

// Multiprecision subtract function. Works on dwords.
// Returns TRUE for carry flag set and underflow,
// else FALSE.
//...................................................
BOOL MpSubDW(LPBYTE lpDestination, LPBYTE lpSource, DWORD dwDwordCount)
{
	BOOL bResult = FALSE;

	if (dwDwordCount)
	{
		__asm
		{
			mov		edi,lpDestination
			mov		esi,lpSource
			mov		ecx,dwDwordCount
			xor		edx,edx
			clc
			align	4
		L1:	mov		eax,dword ptr [esi][edx*4]
			sbb		dword ptr [edi][edx*4],eax
			inc		edx
			dec		ecx
			jnz		L1
			jnc		L2
			mov		bResult,1
		}
	}
	L2:
	return(bResult);
}

// Count the bits, bytes, and dwords in a multiprecision number.
// Returns values in dwCountBits, dwCountBytes, and dwCountDwords.
//................................................................
VOID CountBBD(LPBYTE lpOperand, DWORD dwByteCount)
{
	__asm
	{
		// Make sure byte count is a multiple of 4.
		//.........................................
		mov		eax,dwByteCount
		add		eax,3
		shr		eax,2
		shl		eax,2
		mov		esi,lpOperand
		add		esi,eax
		sub		esi,4			// Point to end dword
		mov		ecx,eax
		shr		ecx,2			// ecx = dword count
		mov		ebx,eax
		shl		ebx,3			// ebx = total possible bits
		align	4
	L1: sub		ebx,32
		mov		eax,dword ptr [esi]
		bsr		edx,eax
		jz		L2
		inc		edx
		add		ebx,edx
		jmp		L3
	L2: sub		esi,4
		dec		ecx
		jnz		L1

		// Bit count in ebx. Calculate the byte count.
		//............................................
	L3: mov		dwCountBits,ebx
		mov		eax,ebx
		add		eax,7
		shr		eax,3
		mov		dwCountBytes,eax

		// Calculate the dword count.
		//...........................
		mov		eax,ebx
		add		eax,31
		shr		eax,5
		mov		dwCountDwords,eax
	}
}

// Compare two multiprecision numbers. Works on dwords.
// Returns 0 if the two are equal. 1 if destination is 
// larger than the source. -1 if destination is smaller
// than the source. 0 is the same as zero flag set. 1 is
// the same as carry flag set. -1 is the same as carry
// and zero flags clear.
//.....................................................
DWORD MpCompareDW(LPBYTE lpSource, LPBYTE lpDestination, DWORD dwDwordCount)
{
	DWORD dwResult = 0;

	if (dwDwordCount)
	{
		__asm
		{
			mov		edi,lpDestination
			mov		esi,lpSource
			mov		ecx,dwDwordCount

			// Point esi and edi to the last dword of the 
			// multiprecision numbers. A compare has to be
			// done from the msb to the lsb.
			//............................................
			mov		edx,ecx
			shl		edx,2
			sub		edx,4
			add		edi,edx
			add		esi,edx
			std
			repe	cmpsd
			cld
			jnz		L1
			mov		dwResult,0
			jmp		L3
		L1: jnc		L2
			mov		dwResult,1
			jmp		L3
		L2:	mov		dwResult,-1
		L3:
		}
	}
	return(dwResult);
}

// Shift left a multiprecison number by 1, thereby
// multiplying it by 2. Works on dwords.
//................................................
VOID MpShlDW(LPBYTE lpOperand, DWORD dwDwordCount)
{
	if (dwDwordCount)
	{
		__asm
		{
			mov		edi,lpOperand
			mov		ecx,dwDwordCount
			xor		esi,esi
			clc
			align	4
		L1: rcl		dword ptr [edi][esi*4],1
			inc		esi
			dec		ecx
			jnz		L1
		}
	}
}

// Shift right a multiprecision number by 1, thereby
// dividing it by 2. Works on dwords.
//..................................................
VOID MpShrDW(LPBYTE lpOperand, DWORD dwDwordCount)
{
	if (dwDwordCount)
	{
		__asm
		{
			mov		edi,lpOperand
			mov		ecx,dwDwordCount

			// Make esi an index to the last dword.
			//.....................................
			mov		esi,ecx
			dec		esi
			clc
		L1: rcr		dword ptr [edi][esi*4],1
			dec		esi
			dec		ecx
			jnz		L1
		}
	}
}

// Multiprecision multiply function. Works on dwords.
//...................................................
BOOL MpMultDW(LPBYTE lpProduct, LPBYTE lpMultiplicand, LPBYTE lpMultiplier, 
			  DWORD dwMultiplicandDwords, DWORD dwMultiplierDwords)
{
	DWORD dwPartialProd;

	if (dwMultiplicandDwords == 0 || dwMultiplierDwords == 0)
	{
		return(FALSE);
	}

	__asm
	{
		// Clear the product field which will equal the length of
		// the multiplicand and multiplier.
		//.......................................................
		mov		edi,lpProduct
		mov		ecx,dwMultiplicandDwords
		add		ecx,dwMultiplierDwords
		xor		eax,eax
		rep		stosd

		// Setup the ourter loop.
		//.......................
		mov		esi,lpMultiplicand
		xor		ebx,ebx				// Outer loop counter
		align	4
	L1: mov		dwPartialProd,0		// Initialize partial product
		xor		ecx,ecx				// Inner loop counter
		align	4

		// Get a dword from the mulitplicand. ecx used as an index.
		//.........................................................
	L2:	mov		eax,dword ptr [esi+ecx*4]
		pushad
	}
	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		_asm
		{
			popad
		}
		return(FALSE);
	}

	__asm
	{
		popad
		// Multiplier to edi. ebx used as an index.
		// Multiply multiplicand by multiplier.
		//.........................................
		mov		edi,lpMultiplier
		mul		dword ptr [edi+ebx*4]

		// Product to edi.
		//...............
		mov		edi,lpProduct

		// Add any partial product to result.
		//...................................
		add		eax,dwPartialProd
		adc 	edx,0
		add		ebx,ecx

		// Plus any partial product from the product.
		//...........................................
		add		eax,dword ptr [edi+ebx*4]
		adc		edx,0

		// Put the result back into the product in its proper place.
		//..........................................................
		mov		dword ptr [edi+ebx*4],eax

		// Save new partial product in dwPartialProd.
		//...........................................
		mov		dwPartialProd,edx
		sub		ebx,ecx
		inc		ecx
		cmp		ecx,dwMultiplicandDwords
		jne		L2

		// We are done with the inner loop. Put the final partial
		// product into its place in the product.
		//.......................................................
		push	ebx
		add		ebx,dwMultiplicandDwords
		mov		dword ptr [edi+ebx*4],edx
		pop		ebx
		inc		ebx
		cmp		ebx,dwMultiplierDwords
		jne		L1
	}
	return(TRUE);
}

// Encipher the secret components of the secret key. The correct
// pass phrase is required to decipher it.
//..............................................................
BOOL EncipherSecretComponents(LPBYTE lpPassPhrase, LPBYTE lpSecretComponents,
							  DWORD dwPPCount, DWORD dwSCCount)
{
	LPBYTE	lpCipherFeedBack;
	DWORD	dwSCBits;
	DWORD	dwShift;

	__asm
	{
		mov		eax,dwSCCount
		shl		eax,3
		mov		dwSCBits,eax
		mov		edi,lpSecretComponents

		// Setup the cipher feedback address which is just before
		// the secret key components.
		//.......................................................
		mov		lpCipherFeedBack,edi
		sub		lpCipherFeedBack,CFB_LENGTH
		mov		esi,lpCipherFeedBack

		// First use the bytes of the cipher feedback to xnor the
		// data in the secret components.
		//.......................................................
		mov		ecx,CFB_LENGTH
	L1: push	ecx
		xor		ebx,ebx
		mov		ecx,dwSCCount
		lodsb
	L2:	xor		byte ptr [edi][ebx],al
		not		byte ptr [edi][ebx]
		inc		ebx
		dec		ecx
		jnz		L2
		pop		ecx
		dec		ecx
		jnz		L1

		// Calculate a check value on the cipher feed back. This
		// method produces a check value that is dependent on the
		// value of each byte and the order also.
		//.......................................................
		mov		esi,lpCipherFeedBack
		xor		edx,edx
		mov		ecx,CFB_LENGTH
	L3: lodsb
		xor		dl,al
		rol		dx,1
		dec		ecx
		jnz		L3

		// If edx is greater than dwSCBits divide edx by dwSCBits
		// and use the remainder for the rotate.
		//.......................................................
		cmp		edx,dwSCBits
		jbe		L4
		mov		eax,edx
		xor		edx,edx
		mov		ecx,dwSCBits
		div		ecx

		// See if it is a multiple of 8.
		//..............................
	L4:	test	edx,07h
		jnz		L5
		inc		edx
	L5:	mov		dwShift,edx
	}
	// Now rotate the bit field of the secret components left
	// by the number of bits calculated.
	//.......................................................
	RotateBitFieldLeft(lpSecretComponents,dwSCCount,dwShift);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		return(FALSE);
	}
	// Now use the pass phrase to hide the cipher feedback data.
	//..........................................................
	__asm
	{
		mov		esi,lpPassPhrase
		mov		edi,lpCipherFeedBack
		mov		ecx,dwPPCount
	L6:	push	ecx
		xor		ebx,ebx
		mov		ecx,CFB_LENGTH
		lodsb
	L7:	xor		byte ptr [edi][ebx],al
		not		byte ptr [edi][ebx]
		inc		ebx
		dec		ecx
		jnz		L7
		pop		ecx
		dec		ecx
		jnz		L6

		// Calculate a check value on the pass phrase.
		//............................................
		mov		esi,lpPassPhrase
		xor		edx,edx
		mov		ecx,dwPPCount
	L8: lodsb
		xor		dl,al
		rol		dx,1
		dec		ecx
		jnz		L8

		// If edx is greater than the CFB*3 divide edx by
		// the number of CFB*3 and use the remainder for
		// the shift count.
		//..................................................
		cmp		edx,(CFB_LENGTH*3)
		jbe		L9
		mov		eax,edx
		xor		edx,edx
		mov		ecx,(CFB_LENGTH*3)
		div		ecx

		// See if it is a multiple of 8.
		//..............................
	L9:	test	edx,07h
		jnz		L0
		inc		edx
	L0:	mov		dwShift,edx
	}
	// Rotate the cipher feedback field.
	//..................................
	RotateBitFieldRight(lpCipherFeedBack,CFB_LENGTH,dwShift);
	return(TRUE);
}

// Decipher the secret components of the secret key. The correct
// pass phrase is required.
//..............................................................
BOOL DecipherSecretComponents(LPBYTE lpPassPhrase, LPBYTE lpSecretComponents,
							  DWORD dwPPCount, DWORD dwSCCount)
{
	LPBYTE	lpCipherFeedBack;
	DWORD	dwSCBits;
	DWORD	dwShift;

	__asm
	{
		mov		eax,dwSCCount
		shl		eax,3
		mov		dwSCBits,eax

		// Setup the cipher feedback address.
		//...................................
		mov		edi,lpSecretComponents
		mov		lpCipherFeedBack,edi
		sub		lpCipherFeedBack,CFB_LENGTH

		// First use the pass phrase to unrotate the cipher feedback
		// field.
		//..........................................................
		mov		esi,lpPassPhrase
		xor		edx,edx
		mov		ecx,dwPPCount
	L1: lodsb
		xor		dl,al
		rol		dx,1
		dec		ecx
		jnz		L1

		// If edx is greater than CFB*3 divide edx by CFB*3
		// and use the remainder for the rotate.
		//.................................................
		cmp		edx,(CFB_LENGTH*3)
		jbe		L2
		mov		eax,edx
		xor		edx,edx
		mov		ecx,(CFB_LENGTH*3)
		div		ecx

		// See if it is a multiple of 8.
		//..............................
	L2:	test	edx,07h
		jnz		L3
		inc		edx
	L3: mov		dwShift,edx
	}
	// Rotate the cipher feedback field left.
	//.......................................
	RotateBitFieldLeft(lpCipherFeedBack,CFB_LENGTH,dwShift);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		return(FALSE);
	}
	// Now use the pass phrase to un xnor the cipher feedback.
	//........................................................
	__asm
	{
		mov		esi,lpPassPhrase
		mov		edi,lpCipherFeedBack
		mov		ecx,dwPPCount
	L4:	push	ecx
		xor		ebx,ebx
		mov		ecx,CFB_LENGTH
		lodsb
	L5:	xor		byte ptr [edi][ebx],al
		not		byte ptr [edi][ebx]
		inc		ebx
		dec		ecx
		jnz		L5
		pop		ecx
		dec		ecx
		jnz		L4

		// Calculate a check value on the cipher feedback.
		//................................................
		mov		esi,lpCipherFeedBack
		xor		edx,edx
		mov		ecx,CFB_LENGTH
	L6:	lodsb
		xor		dl,al
		rol		dx,1
		dec		ecx
		jnz		L6

		// If edx is greater than dwSCBits divide edx by dwSCBits
		// and use the remainder for the rotate.
		//.......................................................
		cmp		edx,dwSCBits
		jbe		L7
		mov		eax,edx
		xor		edx,edx
		mov		ecx,dwSCBits
		div		ecx

		// See if it is a multiple of 8.
		//..............................
	L7:	test	edx,07h
		jnz		L8
		inc		edx
	L8:	mov		dwShift,edx
	}

	// Now rotate the bit field of the secret components
	// right the number of bits calculated.
	//...................................................
	RotateBitFieldRight(lpSecretComponents,dwSCCount,dwShift);

	// Now use the bytes of the cipher feedback to un xnor the
	// date in the secret components.
	//........................................................
	__asm
	{
		mov		esi,lpCipherFeedBack
		mov		edi,lpSecretComponents
		mov		ecx,CFB_LENGTH
	L9: push	ecx
		xor		ebx,ebx
		mov		ecx,dwSCCount
		lodsb
	L0: xor		byte ptr [edi][ebx],al
		not		byte ptr [edi][ebx]
		inc		ebx
		dec		ecx
		jnz		L0
		pop		ecx
		dec		ecx
		jnz		L9
	}
	return(TRUE);
}

// Multiprecision fast mod operation using a short 16 bit modulus.
// Returns -1 if divisor is 0, else the 16 bit remainder in a dword.
//.................................................................
DWORD MpShortMod(LPBYTE lpDividend, DWORD dwDivisor, DWORD dwBits)
{
	DWORD	dwRemainder;

	if (dwDivisor == 0)
	{
		return(-1);
	}
	
	__asm
	{
		xor		eax,eax			// Clear remainder
		mov		edi,lpDividend
		mov		esi,dwDivisor
		mov		ecx,dwBits
		align	4
	L1:	push	ecx
		dec		ecx				// Make 0 based
		shl		eax,1			// Shift remainder left 1 bit
		mov		ebx,ecx
		shr		ebx,3
		and		ecx,07h
		mov		edx,dword ptr [edi][ebx]
		bt		edx,ecx
		jnc		L2
		inc		eax

		// If remainder is greater than or equal to the divisor
		// subtract divisor from the remainder.
	L2:	cmp		eax,esi
		jb		L3
		sub		eax,esi
	L3:	pop		ecx
		dec		ecx
		jnz		L1
		mov		dwRemainder,eax
	}
	return(dwRemainder);
}

// Build a table of remainders relative to our random prime
// suspect for use by the fast sieve function. Returns FALSE
// if we have an error.
//.........................................................
BOOL BuildSieve(LPBYTE lpPrimeSuspect, DWORD dwBits, LPBYTE lpPrimesTable,
				LPBYTE lpRemaindersTable, DWORD dwEntries)
{
	LPBYTE	lpRemTable;
	LPBYTE	lpPriTable;
	DWORD	dwOurEntries;
	DWORD	dwPrimeNumber;
	DWORD	dwRemainder;

	lpRemTable = lpRemaindersTable;
	lpPriTable = lpPrimesTable;
	dwOurEntries = dwEntries;

	while (dwOurEntries != 0)
	{
		// Load the prime number from its table.
		//......................................
		__asm
		{
			mov		esi,lpPriTable
			lodsd
			mov		dwPrimeNumber,eax
			mov		lpPriTable,esi
		}

		dwRemainder = MpShortMod(lpPrimeSuspect,dwPrimeNumber,dwBits);

		// Check for an error.
		//....................
		if (dwRemainder == -1)
		{
			return(FALSE);
		}
		// See if we want to quit.
		//........................
		CheckForMessages();
		if (bCancelOperation)
		{
			return(FALSE);
		}
		// Store the remainder in the remainders table.
		//.............................................
		__asm
		{
			mov		edi,lpRemTable
			mov		eax,dwRemainder
			stosd
			mov		lpRemTable,edi
		}
		dwOurEntries--;
	}
	return(TRUE);
}
